#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://172.31.223.227:4450/admin"
$AdminUser = "API_admin"
$password = "alaska12#"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")

###############################################################################################


# Get sites
Write-Output "Site"
Write-Output "----"
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json
foreach ($site in $siteList.data)
{
    Write-Output ("Site  $($site.id): $($site.attributes.name)")
}
Write-Host $siteID

$siteID = $siteList.data[0].id

####Added 2/01/2022
### Returns all site settings for the specified Site ID ###
### User must obtain the SiteID from Get Sites
Write-Output "Site"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json


####Added 2/02/2022
### Returns all site Metrics for the specified Site ID ###
### User must obtain the SiteID from Get Sites
Write-Output "Site Metrics"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/metrics" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json


####Added 2/02/2022
### GET Site Authentication Provider (EFT, AD, LDAP, ODBC) ###
### User must obtain the SiteID from Get Sites
Write-Output "Site Authentication Provider "
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/authentication" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json


####Added 2/03/2022
### GET Site General Settings###
### User must obtain the SiteID from Get Sites
Write-Output "Site General Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/general" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json


####Added 2/03/2022
### PATCH Site General Settings###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH Site General Settings"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "",
    "type": "",
    "attributes": {
      "siteRootFolder": "C:\\InetPub\\EFTRoot\\MySite\\",
      "overrideVfsCredentials": {
        "enabled": true,
        "value": {
          "login": "test",
          "password": "passwordtest"
        }
      }
    }
  }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 9
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/general" -Method 'PATCH' -Headers $authHeader -Body $update


####Added 2/03/2022
### GET Site FTP(S) Settings###
### User must obtain the SiteID from Get Sites
Write-Output "Site FTP(S) Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ftps" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json

####Added 2/03/2022
### PATCH FTP(S) Settings###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH FTP(S) Settings"
Write-Output "-----"
$update = 
'{
  "data": {
    "attributes":{
      "ftp": {
        "enabled": true,
        "port": 25
      }
    }
  }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 9
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ftps" -Method 'PATCH' -Headers $authHeader -Body $update



####Added 2/03/2022
### GET Site HTTP(s) Settings###
### User must obtain the SiteID from Get Sites
Write-Output "Site HTTPS(S) Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/https" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json



### PATCH  Site HTTP(s) Settings###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH  Site HTTP(s) Settings"
Write-Output "-----"
$update = 
'{
  "data": {
    "attributes":{
      "https": {
        "enabled": true,
        "port": 25
      }
    }
  }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 9
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/https" -Method 'PATCH' -Headers $authHeader -Body $update




####Added 2/03/2022
### GET Site Network and Security Settings###
### User must obtain the SiteID from Get Sites
Write-Output "GET Site Network and Security Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/networkandsecurity" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json



####Added 2/04/2022
### GET Site IP access/ban list Settings###
### User must obtain the SiteID from Get Sites
Write-Output "GET Site IP access/ban list Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAccessList" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json

####Added 2/04/2022
### POST Site IP access/ban list Settings###
### User must obtain the SiteID from Get Sites
Write-Output "POST Site IP access/ban list Settings"
Write-Output "-----"
$update = 
'
{
  "data": {
    "id": "192.168.100.75",
    "type": "access",
    "attributes": {
      "accessType": "Allow",
      "reason": "API TEST",
      "sequenceNumber": 3
    }
  }
}
'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 9
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAccessList" -Method 'POST' -Headers $authHeader -Body $update




####Added 2/07/2022
### GET Site IP access/ban list Settings###
### User must obtain the SiteID from Get Sites
Write-Output "GET Site IP access/ban list Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAccessList" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json

$ipAccessId = $siteList.data[0].id


####Added 2/07/2022
### GET Site IP access/ban Settings For specific IP ###
### User must obtain the SiteID from Get Sites
Write-Output "GET Site IP access/ban list Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAccessList/$ipAccessId" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json



### Added 2/07/2022
### PATCH Site Network and Security Settings For specific IP###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH Site Network and Security Settings For specific IP"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "192.168.100.75",
    "attributes": {
      "accessType": "Allow",
      "reason": "This is a test for PS PATCH on IP",
      "sequenceNumber": 1
    }
  }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 9
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAccessList/$ipAccessId" -Method 'PATCH' -Headers $authHeader -Body $update


####Added 2/07/2022
### DELETE Site IP access/ban Settings For specific IP ###
### User must obtain the SiteID from Get Sites
### User must obtain the IP id to be deleted ###
Write-Output "DELETE Site IP access/ban Settings For specific IP ###"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAccessList/$ipAccessId" -Method 'DELETE' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json


####Added 2/08/2022 Endpoint fails to return data ### 
### GET IPs in the Autoban List###
Write-Output "GET Site IP access/ban list Settings"
Write-Output "----"
#$siteID = Enter SiteID here
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/ipAutoBanList" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json


####Added 2/08/2022 ### 
###GET SMS Settings for Site###
Write-Output "GET SMS Settings for Site"
Write-Output "----"
#$siteID = "Enter site ID"
$smsList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sms" -Method 'GET' -Headers $authHeader
Write-Output $smsList | ConvertTo-Json -Depth 25



####Added 2/08/2022
### POST add a new SMS profile ###
### User must obtain the SiteID from Get Sites
Write-Output "add a new SMS profile "
Write-Output "----------------------"
$update = 
'{
  "data": {
    "attributes": {
      "name": "PowerShell Example",
      "serviceType": "genericSmsProviderProfile",
      "services": {
        "accountSid": "AAAAAAAAAAAAAAAAAAAAAAe",
        "authToken": "0dddd0dddd0dddd0dddd",
        "twilioNumber": "+1210210210",
        "message": "Your passcode is: %Account_Session_OTP%",
        "postUrl": "https://api.twilio.com/2010-04-01/Accounts/%SID%/Messages"
      },
      "proxy": {
        "enabled": true,
        "type": "192.168.100.100",
        "hostName": "testproxy",
        "port": 1443,
        "userName": "TestUser",
        "password": "example"
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 25
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sms" -Method 'POST' -Headers $authHeader -Body $update


####Added 2/08/2022 ### 
###GET specific profile SMS Configuration Details###
Write-Output "GET specific profile SMS Configuration Details"
Write-Output "----"
$profileName = "PowerShell Example"
$smsList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sms/$profileName" -Method 'GET' -Headers $authHeader
Write-Output $smsList | ConvertTo-Json -Depth 25


####Added 2/08/2022
### PATCH - Updates existing SMS profile ###
### User must obtain the SiteID from Get Sites
Write-Output "add a new SMS profile "
Write-Output "----------------------"
$profileName = "PowerShell Example"
$update = 
'{
  "data": {
    "attributes": {
      "name": "",
      "serviceType": "genericSmsProviderProfile",
      "services": {
        "accountSid": "43243243214324234321FDGFDSG",
        "authToken": "ABCDEFT1234567899",
        "twilioNumber": "210101010101",
        "message": "Your passcode is: %Account_Session_OTP%",
        "postUrl": "https://api.twilio.com/2010-04-01/Accounts/%SID%/Messages"
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 25
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sms/$profileName" -Method 'PATCH' -Headers $authHeader -Body $update





####Added 2/08/2022 ### 
###### DELETE SMS specific profile######
Write-Output "### DELETE SMS specific profile###"
Write-Output "----"
$profileName = "PowerShell Example"
$smsList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sms/$profileName" -Method 'DELETE' -Headers $authHeader
Write-Output $smsList | ConvertTo-Json -Depth 25




####Added 2/09/2022 ### 
###GET Account Security Configuration Details###
Write-Output "GET specific profile SMS Configuration Details"
Write-Output "----"
$profileName = "PowerShell Example"
$smsList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/accountSecurity" -Method 'GET' -Headers $authHeader
Write-Output $smsList | ConvertTo-Json -Depth 25



####Added 2/09/2022
### PATCH Account Security Configuration Details ###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH Account Security Configuration Details"
Write-Output "----------------------"
$update = 
'{
  "data": {
    "attributes": {
      "accountPolicy": {
        "invalidLogin": {
          "account": {
            "enabled": true,
            "action": "Disable",
            "attemptPeriodMinutes": 3,
            "attemptRetries": 3,
            "lockoutMinutes": 3
          },
          "ip": {
            "enabled": true,
            "attemptPeriodMinutes": 3,
            "attemptRetries": 3,
            "inCorrectLoginType": "NameOrPassword"
          }
        }
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 25
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/accountSecurity" -Method 'PATCH' -Headers $authHeader -Body $update



####Added 2/09/2022 ### 
###GET workspaces Configuration Details###
Write-Output "GET workspaces Configuration Details"
Write-Output "----"
#$siteID = "Enter site ID"
$wksList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/workspaces" -Method 'GET' -Headers $authHeader
Write-Output $wksList | ConvertTo-Json -Depth 25



####Added 2/10/2022 ### 
###GET Send Portal Configuration Details###
Write-Output "GET Send Portal Configuration Details"
Write-Output "-------------------------------------"
#$siteID = "Enter site ID"
$SendList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sendPortal" -Method 'GET' -Headers $authHeader
Write-Output $Sendlist | ConvertTo-Json -Depth 25


####Added 2/10/2022
### PATCH Send Portal Configuration Details ###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH Send Portal Configuration Details"
Write-Output "----------------------------------------"
$update = 
'{
  "data": {
    "type": "sendPortal",
    "attributes": {
      "enabled": true,
      "recipients": "UsersGuestsAnonymous",
      "allowedDomains": {
        "enabled": true,
        "list": [
          "outlook.*", "yahoo.*"
        ]
      },
      "deniedDomains": {
        "enabled": true,
        "list": [
          "GSB.*"
        ]
      },
      "reservedPath": "/send",
      "protocol": "http",
      "hostName": "12.12.12.12",
      "port": "333",
      "autoAttachInOutlook": {
        "enabled": false,
        "whenExceedMbytes": 10
      },
      "linkExpiration": {
        "value": 1,
        "units": "Month"
      },
      "retainFilesAfterLinkExpiration": {
        "value": 1,
        "unit": "Day"
      },
      "allowRepliesWithFiles": true,
      "sendEntireMessageSecurely": "LetUserChoose",
      "outOfBandPasscode": "Sender chooses",
      "secondVerification": "email",
      "fileRequestPortal": {
        "enabled": false,
        "reservedPath": "/request"
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 25
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sendPortal" -Method 'PATCH' -Headers $authHeader -Body $update


####Added 2/11/2022 ### 
###GET Drop Off Portal Settings###
Write-Output "GET Drop Off Portal Settings"
Write-Output "----------------------------"
#$siteID = "Enter site ID"
$DropOfflist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/dropOffPortal" -Method 'GET' -Headers $authHeader
Write-Output $DropOfflist | ConvertTo-Json -Depth 25


####Added 2/11/2022
### PATCH Drop Off Portal Settings###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH Drop Off Portal Settings"
Write-Output "------------------------------"
$update = 
'{
  "data": {
    "type": "dropOffPortal",
    "attributes": {
      "enabled": true,
      "reservedPath": "/dropoff",
      "captcha": {
        "type": "reCAPTCHA",
        "value": {
          "siteKey": "6LeXY8odfasdfdsafdsafdsfsdfdsfdsfsdfdsfds-afar",
          "secretKey": "6Ldfasdfdsafdsafsdafdsafsdasfdsafdsfsd-afar"
        }
      },
      "linkExpiration": {
        "value": 1,
        "units": "Week"
      },
      "maxMessageSize": {
        "enabled": true,
        "mBytes": 2048
      },
      "sendEntireMessageSecurely": "LetUserChoose",
      "userEmailOption": {
        "allowToEnterToEmailAddress": true,
        "allowedDomains": {
          "enabled": true,
          "list": [
            "*.*"
          ]
        }
      },
      "addressBookList": []
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 30
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/dropOffPortal" -Method 'PATCH' -Headers $authHeader -Body $update



####Added 2/11/2022 ### 
###GET Privacy Policy  Settings###
Write-Output "GET Privacy Policy  Settings"
Write-Output "----------------------------"
#$siteID = "Enter site ID"
$PPlist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/privacyPolicy" -Method 'GET' -Headers $authHeader
Write-Output $PPlist | ConvertTo-Json -Depth 25

####Added 2/11/2022
### PATCH Privacy Policy  Settings###
### User must obtain the SiteID from Get Sites
Write-Output "Privacy Policy  Settings"
Write-Output "------------------------------"
$update = 
'{
  "data": {
    "type": "privacyPolicy",
    "attributes": {
      "type": "Mandatory",
      "values": {
        "preventSftpsUntilAgreed": true,
        "impliedForNonSubjects": true
      },
      "agreementPath": "",
      "agreementLabel": "",
      "effectiveDate": "Feb 11, 2020. 01:01:39 PM"
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 30
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/privacyPolicy" -Method 'PATCH' -Headers $authHeader -Body $update


####Added 2/11/2022 ### 
###GET terms Of Service Settings###
Write-Output "GET terms Of Service Settings"
Write-Output "----------------------------"
#$siteID = "Enter site ID"
$TOSlist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/termsOfService" -Method 'GET' -Headers $authHeader
Write-Output $TOSlist | ConvertTo-Json -Depth 25


####Added 2/11/2022
### PATCH terms Of Service Settings###
### User must obtain the SiteID from Get Sites
Write-Output "terms Of Service Settings"
Write-Output "--------------------------"
$update = 
'{
  "data": {
    "type": "termsOfService",
    "attributes": {
      "type": "Mandatory",
      "values": {
        "preventSftpsUntilAgreed": true
      },  
      "agreementPath": "",
      "agreementLabel": "",
      "effectiveDate": "Dec 16, 2000. 10:05:17 AM"
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 30
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/termsOfService" -Method 'PATCH' -Headers $authHeader -Body $update


####Added 2/14/2022 ### 
###GET GDRP Settings###
Write-Output "GET GDRP Settings"
Write-Output "-----------------"
#$siteID = "Enter site ID"
$GDPRlist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/gdpr" -Method 'GET' -Headers $authHeader
Write-Output $GDPRlist | ConvertTo-Json -Depth 25


####Added 2/14/2022
### PATCH GDRP Settings###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH GDRP Settings"
Write-Output "-------------------"
$update = 
'{
  "data": {
    "type": "gdpr",
    "attributes": {
      "materialScope": "In scope",
      "territorialScope": {
        "type": "In Union, all subjects in scope (3.1)",
        "value": {
          "showEUStatus": true,
          "allUsersToChangeEUSubject": true
        }
      },
      "processingPrinciples": "General guidance not yet met",
      "lawfulnessOfProcessing": "Data subject consent (6.1.a)",
      "conditionsForConsent": "Set via EFT\u0027s ToS or Privacy Policy",
      "ageRestrictions": "Enforced via EFT\u0027s ToS or Privacy Policy",
      "transparentInformation": "Communicated via EFT\u0027s ToS or Privacy Policy",
      "directCollection": "Communicated via EFT\u0027s ToS or Privacy Policy",
      "indirectCollection": "Communicated via EFT\u0027s ToS or Privacy Policy",
      "rightOfAccess": "Exercised via EFT\u0027s web client",
      "rightToRectify": "Exercised via EFT\u0027s web client",
      "rightToBeForgotten": "Exercised via EFT\u0027s web client",
      "rightToRestrict": "Exercised via EFT\u0027s web client",
      "rightToBeNotified": "Exercised via EFT\u0027s event rules",
      "rightToExport": "Exercised via EFT\u0027s web client",
      "rightToObject": "Exercised via EFT\u0027s web client",
      "encryption": "Personal data is encrypted by EFT",
      "limitedAccess": "Configured By EFT",
      "purpose": {
        "type": "Configured By EFT",
        "reason": ""
      },
      "necessity": {
        "type": "Configured By EFT",
        "reason": ""
      },
      "riskAssessment": "EFT generated DPIA report",
      "riskMitigation": {
        "type": "Configured By EFT",
        "reason": ""
      },
      "dpoAssigned": {
        "type": "Configured By EFT",
        "email": "pofficer@mail.com"
      },
      "transferSafeguard": "Configured By EFT"
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 30
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/gdpr" -Method 'PATCH' -Headers $authHeader -Body $update



####Added 2/14/2022 ### 
###GET Upload Forms Settings###
Write-Output "GET Upload Forms Settings"
Write-Output "-----------------"
#$siteID = "Enter site ID"
$UpFormslist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/uploadForms" -Method 'GET' -Headers $authHeader
Write-Output $UpFormslist | ConvertTo-Json -Depth 25



####Added 2/14/2022 ### 
###GET User Groups###
Write-Output "GET User Groups"
Write-Output "-----------------"
#$siteID = "Enter site ID"
$Uglist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/userGroups" -Method 'GET' -Headers $authHeader
Write-Output $Uglist | ConvertTo-Json -Depth 25



####Added 2/14/2022 ### 
###GET outlook Deployment Script###
Write-Output "GET outlook Deployment Script"
Write-Output "-----------------"
#$siteID = "Enter site ID"
$ODSlist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/outlookDeploymentScript" -Method 'GET' -Headers $authHeader
Write-Output $ODSlist | ConvertTo-Json -Depth 25


####Added 2/14/2022 ### 
###GET list of Content Integrity Profiles###
Write-Output "GET list of Content Integrity Profiles"
Write-Output "--------------------------------------"
#$siteID = "Enter site ID"
$CIClist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/contentIntegrity" -Method 'GET' -Headers $authHeader
Write-Output $CIClist | ConvertTo-Json -Depth 25

$profileId = $CICList.data[0].id



####Added 2/15/2022 ### 
###POST Create New Content Integrity Profile###
Write-Output " Create New Content Integrity Profile"
Write-Output "-------------------------------------"
$update = 
'{
  "data": {
    "type": "contentIntegrity",
    "attributes": {
      "profileName": "Profile_API_TEST6",
      "host": "192.168.100.82",
      "port": 1344,
      "path": "/reqmode",
      "mode": "REQMOD",
      "scanLimit": {
        "enabled": true,
        "bytes": 100000
      },
      "headerOverrides": {
        "httpHost": {
          "enabled": true,
          "value": "192.168.100.83"
        },
        "xClientIp": {
          "enabled": true,
          "value": "192.168.100.52"
        },
        "xServerIp": {
          "enabled": true,
          "value": "192.168.100.60"
        },
        "xSubscriberIp": {
          "enabled": true,
          "value": "192.168.100.70"
        },
        "xAuthenticatedUser": {
          "enabled": true,
          "value": "192.186.100.12"
        },
        "xAuthenticatedGroups": {
          "enabled": true,
          "value": "Local://%USER.Log%"
        }
      },
      "responseHandling": {
        "continueOnConnectivityError": "Continue",
        "continueOnHttpError": "Continue",
        "continueOnIcapViolation": "Fail",
        "continueOnIcapRedaction": "Continue",
        "customHeadersToAudit": {
          "enabled": true,
          "headers": []
        }
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 25
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/contentIntegrity" -Method 'POST' -Headers $authHeader -Body $update


####Added 2/15/2022 ### 
###GET specific Content Integrity Profile settings###
### User must obtain the Profile ID and manually enter it or by holding the value on a variable ###
Write-Output "GET specific Content Integrity Profile settings"
Write-Output "----------------------------------------------"
#$profileID = "53f00be5-9aa0-41ed-9fdf-ea99f6784238"
$SCIlist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/contentIntegrity/$profileId" -Method 'GET' -Headers $authHeader
Write-Output $SCIlist | ConvertTo-Json -Depth 35


####Added 2/15/2022
### PATCH specific Content Integrity Profile settings###
### User must obtain the Profile ID and manually enter it or by holding the value on a variable ###
Write-Output "PATCH specific Content Integrity Profile settings"
Write-Output "------------------------------------------------"
$update = 
'{
  "data": {
    "type": "contentIntegrity",
    "attributes": {
      "profileName": "Profile_API_TEST_PATCH",
      "host": true,
      "port": 1344,
      "path": true,
      "mode": "REQMOD",
      "scanLimit": {
        "enabled": true,
        "bytes": 100000
      },
      "headerOverrides": {
        "httpHost": {
          "enabled": true,
          "value": "192.168.100.00"
        },
        "xClientIp": {
          "enabled": true,
          "value": "192.168.100.00"
        },
        "xServerIp": {
          "enabled": false,
          "value": ""
        },
        "xSubscriberIp": {
          "enabled": false,
          "value": ""
        },
        "xAuthenticatedUser": {
          "enabled": false,
          "value": ""
        },
        "xAuthenticatedGroups": {
          "enabled": false,
          "value": ""
        }
      },
      "responseHandling": {
        "continueOnConnectivityError": "Continue",
        "continueOnHttpError": "Continue",
        "continueOnIcapViolation": "Fail",
        "continueOnIcapRedaction": "Continue",
        "customHeadersToAudit": {
          "enabled": true,
          "headers": []
        }
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 35
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/contentIntegrity/$profileId" -Method 'PATCH' -Headers $authHeader -Body $update



####Added 2/15/2022
###DELETE specific content integrity profile settings####
###Pass the ID of the CIC profile###
###@profileId = 53f00be5-9aa0-41ed-9fdf-ea99f6784238
Write-Output "DELETE specific content integrity profile settings"
Write-Output "-------------------------------------------------"
#$profileID = "53f00be5-9aa0-41ed-9fdf-ea99f6784238"
$DCIClist = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/contentIntegrity/$profileId" -Method 'DELETE' -Headers $authHeader
Write-Output $DCIClist | ConvertTo-Json -Depth 35



####Added 2/08/2022 ### 
###### DELETE SMS specific profile######
Write-Output "### DELETE SMS specific profile###"
Write-Output "----"
$profileName = "PowerShell Example"
$smsList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/sms/$profileName" -Method 'DELETE' -Headers $authHeader
Write-Output $smsList | ConvertTo-Json -Depth 25





####Added 2/02/2022
### PATCH Site Authentication Provider (EFT, AD, LDAP, ODBC) ###
### User must obtain the SiteID from Get Sites
Write-Output "PATCH Site Authentication Provider"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "",
    "type": "site",
    "attributes": {
      "userAuth": {
        "type": "ODBC",
        "odbc": {
          "connectionString": "Provider=MSDASQL;SERVER=192.168.100.70;DATABASE=ODBC;UID=sa;PWD=alaska",
          "encryptUserPassword": true,
          "refreshInterval": {
            "inherited": true,
            "enabled": false,
            "minutes": 0
          }
        }
      },
      "advancedAuth": {
        "type": "radius",
        "radius": {
          "server": "",
          "port": 0,
          "nasIdentifier": "",
          "sharedSecret": "",
          "connectionRetries": 0,
          "timeOutSeconds": 0
        }
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 9
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/authentication" -Method 'PATCH' -Headers $authHeader -Body $update


####Added 2/01/2022
#POST Site/ (Create a new Site) 
Write-Output "POST Site (Create a new Site)"
Write-Output "-----"
$update = 
'{
  "data": {
    "type": "site",
    "attributes": {
      "pciComplianceEnabled": true,
      "siteLabel": "MySite6",
      "siteRootFolder": "C:\\InetPub\\EFTRoot\\MySite\\",
      "createUnixStyleSubFolders": true,
      "createFoldersForNewUsers": true
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'POST' -Headers $authHeader -Body $update


# get users
Write-Output "Users"
Write-Output "-----"
$userList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/users" -Method 'GET' -Headers $authHeader
Write-Output $userList | ConvertTo-Json
foreach ($user in $userList.data)
{
    Write-Output ("User $($user.id): $($user.attributes.loginName)")
}








########################################################################################################
#Added as of 10/8/21

#get Server
Write-Output "Get Server"
Write-Output "-----"
$serverDetails = Invoke-RestMethod -Uri "$baseURL/v2/server" -Method 'GET' -Headers $authHeader
Write-Output $serverDetails | ConvertTo-Json
foreach ($server in $serverDetails.data)
{
    Write-Output ("Server $($serverDetails.data)")
}

##Patch Server - patching the SMTP settings
Write-Output "Server Patch"
Write-Output "-----"
$update = 
'{
    "data":{
        "type": "server",
        "id": "1",
        "attributes": {
            "version": "",
        "smtp": {
            "login": "",
            "password": "",
            "port": 25,
            "senderAddr": "EFT@iv-s2019b-1.com",
            "senderName": "Globalscape EFT",
            "server": "mail.yada2.net",
            "useAuthentication": false,
            "useImplicitTLS": false
         }  
         }
     }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/server" -Method 'PATCH' -Headers $authHeader -Body $update


###
#get Server Metrics
Write-Output "Get Server Metrics"
Write-Output "-----"
$serverMetrics = Invoke-RestMethod -Uri "$baseURL/v2/server/metrics" -Method 'GET' -Headers $authHeader
Write-Output $serverMetrics | ConvertTo-Json
foreach ($server in $serverMetrics.data)
{
    Write-Output ("Server $($serverMetrics.data)")
}

###
#get Server TLS Security Settings
Write-Output "Get Server TLS Settings"
Write-Output "-----"
$serverTLS = Invoke-RestMethod -Uri "$baseURL/v2/server/security/tls" -Method 'GET' -Headers $authHeader
Write-Output $serverTLS | ConvertTo-Json
foreach ($server in $serverTLS.data)
{
    Write-Output ("Server $($serverTLS.data)")
}

###(PATCH) TLS Security Settings (enable FIPS)
Write-Output "Server TLS Enable FIPS Patch"
Write-Output "-----"
$update = 
'{
 "data": {
    "type": "tlsServerSecuritySettings",
    "id": "1",
    "attributes": {
      "tlsFipsEnabled": true
    }
  },
  "links": {
    "self": "admin/v2/server/security/tls"
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/server/security/tls" -Method 'PATCH' -Headers $authHeader -Body $update



###
#get Server SSH Security Settings
Write-Output "Get Server SSH Settings"
Write-Output "-----"
$serverSSH = Invoke-RestMethod -Uri "$baseURL/v2/server/security/ssh" -Method 'GET' -Headers $authHeader
Write-Output $serverSSH | ConvertTo-Json
foreach ($server in $serverSSH.data)
{
    Write-Output ("Server $($serverSSH.data)")
}

###(PATCH) SSH Security Settings (enable FIPS)
Write-Output "Server SSH Enable FIPS Patch"
Write-Output "-----"
$update = 
'{
 "data": {
    "type": "sshServerSecurity",
    "id": "1",
    "attributes": {
      "sshFipsEnabled": true
    }
  },
  "links": {
    "self": "admin/v2/server/security/ssh"
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/server/security/ssh" -Method 'PATCH' -Headers $authHeader -Body $update


###
#get Server DPIA Report
Write-Output "Get Server DPIA Report"
Write-Output "-----"
$serverDPIA = Invoke-RestMethod -Uri "$baseURL/v2/server/reports/DPIA" -Method 'GET' -Headers $authHeader
Write-Output $serverDPIA | ConvertTo-Json -Depth 20
foreach ($server in $serverDPIA.data)
{
    Write-Output ("Server $($serverDPIA.data)")
}

###
#get Server admin users
Write-Output "Get Server admin users"
Write-Output "-----"
$serverAdmins = Invoke-RestMethod -Uri "$baseURL/v2/admin-users" -Method 'GET' -Headers $authHeader
Write-Output $serverAdmins | ConvertTo-Json
foreach ($server in $serverAdmins.data)
{
    Write-Output ("Server $($serverAdmins.data)")
}

###
#POST Server Admin user (New User)
Write-Output "POST Server Admin (New Admin user)"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "1",
    "attributes": {
      "name": "Test_admin",
      "password": "test",
      "adminConsolePermissions": {
        "accountPolicy": "server",
        "enableCom": true,
        "enableEditingAndReporting": true,
        "enablePersonalDataAccess": true
      },
      "restPermissions": {
        "enabled": true,
        "restAdminRole": true
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/admin-users" -Method 'POST' -Headers $authHeader -Body $update

###
#Get Server Admin Details when providing a Server Admin ID
Write-Output "Get Server Admin Details"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/admin-users/59774c12-870d-5560-a44a-c5b35cf68d4c" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}


###
#PATCH Server Admin Details when providing a Server Admin ID
Write-Output "Server Admin User Patch"
$adminID = "13564c1b-8e13-4e72-b8e0-9480fad06221"
Write-Output "Admin ID: $adminID"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "0",
    "attributes": {
        "adminConsolePermissions": {
        "enableCom": false,
        "enableEditingAndReporting": true,
        "enablePersonalDataAccess": true
      },
      "restPermissions": {
        "enabled": true,
        "restAdminRole": true
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/admin-users/$adminID" -Method 'PATCH' -Headers $authHeader -Body $update


###
#DELETE EFT admin by Admin ID
Write-Output "Server Admin DELETE"
$adminID = "f98d2a35-4d37-4891-89ed-66cb6ddf9436"
Write-Output "Admin ID: $adminID"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/admin-users/$adminID" -Method 'DELETE' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}


###
#GET Server Admin user policy
Write-Output "Get Server Admin User Policy"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/admin-users-policy" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}

###
#PATCH Server Admin user policy (disable Admin UI disconnect)
Write-Output "Server Admin User Policy Patch"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "1",
    "type": "adminUserPolicy",
    "attributes": {
      "accountPolicy": {
          "inactivity": {
          "disconnectDueToTimeout": {
            "enabled": false,
            "timeoutMinutes": 5
          }

        }
      }
    }
  }
}'   
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/admin-users-policy" -Method 'PATCH' -Headers $authHeader -Body $update

###
#GET SERVER NODES
Write-Output "Get EFT Server Nodes"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/nodes" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}

###
#GET SERVER NODE METRICS
Write-Output "Get EFT Server Node Metrics"
$serverNodeID = "DTY2019WinServe"
Write-Output "Server Node ID: $serverNodeID"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/nodes/$serverNodeID/metrics" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}

###
#GET SERVER NODE LICENSE
Write-Output "Get EFT Server Node Licenses"
$serverNodeID = "DTY2019WinServe"
Write-Output "Server Node ID: $serverNodeID"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/nodes/$serverNodeID/licenses" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10


###
#POST SERVER NODE LICENSE
Write-Output "Register EFT Server Node"
$serverNodeID = "DTY2019WinServe"
Write-Output "Server Node ID: $serverNodeID"
Write-Output "-----"
$update = 
'{
  "data": [
    {
      "id": "ARMModule",
      "attributes": {
        "serialNumber": "MySerialNumberHere"
      }
    }
  ]
}'   
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/nodes/$serverNodeID/licenses" -Method 'POST' -Headers $authHeader -Body $update



